#ifndef _PLAYER_H
#define _PLAYER_H

extern void add_animation ( BITMAP *ani_bmp, int x, int y, BYTE max_frame, char *text, BYTE color );

#define H_SPEED 4
#define V_SPEED 4

#define CANDY 0
#define CHOCO 1
#define NUT   2
#define HERB  3
#define ROPE  4

typedef struct {
	WORD current_hp, current_mp;
	WORD max_hp, max_mp;
	WORD attack, defense;
	BYTE energy, magic_energy;
	BYTE bag[2][20];
	WORD level;
	WORD xp, next_xp;
	WORD money;
} PLAYER;

PLAYER *create_player ( WORD hp, WORD mp, WORD attack, WORD defense );

void do_item ( PLAYER *, WORD x, WORD y, BYTE item );

void destroy_player ( PLAYER *player );

///////////////////////////////////////

PLAYER *create_player ( WORD hp, WORD mp, WORD attack, WORD defense ) {
	PLAYER *player;
	BYTE i;

	player = ( PLAYER * ) malloc ( sizeof ( PLAYER ) );
	player->current_hp = hp;
	player->current_mp = mp;
	player->max_hp = hp;
	player->max_mp = mp;
	player->attack = attack;
	player->defense = defense;
	player->energy = 4;
	player->magic_energy = 4;
	for ( i=0;i<20;i++ ) {
		player->bag[0][i] = 0;
		player->bag[1][i] = 0;
	}
	player->level = 1;
	player->xp = 0;
	player->next_xp = 10;
	player->money = 0;
	return player;
}

void do_item ( PLAYER *player, WORD x, WORD y, BYTE item ) {
	char text[5];
	switch ( item ) {
	case ( CANDY ):
		player->current_hp += 50;
		if ( player->current_hp > player->max_hp ) player->current_hp = player->max_hp;
		add_animation ( NULL, x, y, 20, itoa ( 50, text, 10 ), 1 );
	break;
	case ( CHOCO ):
		player->current_hp += 100;
		if ( player->current_hp > player->max_hp ) player->current_hp = player->max_hp;
		add_animation ( NULL, x, y, 20, itoa ( 100, text, 10 ), 1 );
	break;
	case ( NUT ):
		player->current_mp += 50;
		if ( player->current_mp > player->max_mp ) player->current_mp = player->max_mp;
		add_animation ( NULL, x, y, 20, itoa ( 50, text, 10 ), 2 );
	}
}

void destroy_player ( PLAYER *player ) {
	free ( player );
}

#endif